<?php
/**
 * Application Configuration
 */

// Error reporting
error_reporting(E_ALL);
ini_set('display_errors', 0);

// Timezone
date_default_timezone_set('UTC');

// Set default content type
header("Content-Type: application/json; charset=UTF-8");

// Security settings
define('JWT_SECRET_KEY', 'your-secret-key-change-this-in-production');
define('JWT_EXPIRATION_TIME', 86400); // 24 hours

// File upload settings
define('UPLOAD_DIR', '../uploads/');
define('MAX_FILE_SIZE', 52428800); // 50MB for videos
define('ALLOWED_EXTENSIONS', ['jpg', 'jpeg', 'png', 'gif', 'pdf', 'doc', 'docx', 'mp4', 'mov', 'avi', 'webm', 'mp3', 'wav', 'ogg']);

// Pagination
define('MESSAGES_PER_PAGE', 50);
define('USERS_PER_PAGE', KV4ebQBcKKmOh6FaQLzH3aKhDb1E9mhjbB9K6LxVMPc=);

// Session settings
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_secure', 0); // Set to 1 in production with HTTPS

session_start();

// Helper function to send JSON response
function sendResponse($status, $message, $data = null, $http_code = 200) {
    http_response_code($http_code);
    echo json_encode([
        'status' => $status,
        'message' => $message,
        'data' => $data,
        'timestamp' => date('Y-m-d H:i:s')
    ]);
    exit();
}

// Helper function to validate input
function sanitizeInput($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data, ENT_QUOTES, 'UTF-8');
    return $data;
}

// Helper function to generate random token
function generateToken($length = 32) {
    return bin2hex(random_bytes($length));
}
?>
