<?php
/**
 * User Notifications API
 */

// Define the root path of the project
define('ROOT_PATH', realpath(__DIR__ . '/../../..'));

require_once ROOT_PATH . '/backend/api/cors.php';
handleCORS();

require_once ROOT_PATH . '/backend/config/database.php';
require_once ROOT_PATH . '/backend/config/config.php';
require_once ROOT_PATH . '/backend/middleware/auth.php';

$user = authenticate();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Get notifications
    try {
        $database = new Database();
        $conn = $database->getConnection();

        $unread_only = isset($_GET['unread']) && $_GET['unread'] === 'true';
        $where_clause = $unread_only ? "AND is_read = 0" : "";

        $query = "SELECT 
                    id,
                    notification_type,
                    title,
                    content,
                    reference_id,
                    is_read,
                    created_at
                  FROM notifications
                  WHERE user_id = :user_id $where_clause
                  ORDER BY created_at DESC
                  LIMIT 50";
        
        $stmt = $conn->prepare($query);
        $stmt->bindParam(':user_id', $user['id']);
        $stmt->execute();

        $notifications = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Get unread count
        $count_query = "SELECT COUNT(*) as unread_count FROM notifications WHERE user_id = :user_id AND is_read = 0";
        $count_stmt = $conn->prepare($count_query);
        $count_stmt->bindParam(':user_id', $user['id']);
        $count_stmt->execute();
        $unread_count = $count_stmt->fetch(PDO::FETCH_ASSOC)['unread_count'];

        sendResponse('success', 'Notifications retrieved', [
            'notifications' => $notifications,
            'unread_count' => (int)$unread_count
        ], 200);

    } catch (PDOException $e) {
        sendResponse('error', 'Database error: ' . $e->getMessage(), null, 500);
    }

} elseif ($_SERVER['REQUEST_METHOD'] === 'PUT') {
    // Mark notification as read
    $data = json_decode(file_get_contents("php://input"));

    try {
        $database = new Database();
        $conn = $database->getConnection();

        if (isset($data->notification_id)) {
            // Mark single notification as read
            $query = "UPDATE notifications SET is_read = 1 WHERE id = :notification_id AND user_id = :user_id";
            $stmt = $conn->prepare($query);
            $stmt->bindParam(':notification_id', $data->notification_id);
            $stmt->bindParam(':user_id', $user['id']);
        } else {
            // Mark all as read
            $query = "UPDATE notifications SET is_read = 1 WHERE user_id = :user_id";
            $stmt = $conn->prepare($query);
            $stmt->bindParam(':user_id', $user['id']);
        }

        if ($stmt->execute()) {
            sendResponse('success', 'Notifications marked as read', null, 200);
        } else {
            sendResponse('error', 'Failed to update notifications', null, 500);
        }

    } catch (PDOException $e) {
        sendResponse('error', 'Database error: ' . $e->getMessage(), null, 500);
    }

} else {
    sendResponse('error', 'Method not allowed', null, 405);
}
?>
