<?php
/**
 * File Upload API
 */

// Define the root path of the project
define('ROOT_PATH', realpath(__DIR__ . '/../../..'));

require_once ROOT_PATH . '/backend/api/cors.php';
handleCORS();

require_once ROOT_PATH . '/backend/config/database.php';
require_once ROOT_PATH . '/backend/config/config.php';
require_once ROOT_PATH . '/backend/middleware/auth.php';

$user = authenticate();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse('error', 'Method not allowed', null, 405);
}

if (!isset($_FILES['file'])) {
    sendResponse('error', 'No file uploaded', null, 400);
}

$file = $_FILES['file'];

// Validate file size
if ($file['size'] > MAX_FILE_SIZE) {
    sendResponse('error', 'File size exceeds maximum limit (5MB)', null, 400);
}

// Validate file extension
$file_extension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
if (!in_array($file_extension, ALLOWED_EXTENSIONS)) {
    sendResponse('error', 'File type not allowed', null, 400);
}

try {
    // Create upload directory if it doesn't exist
    $upload_path = __DIR__ . '/../../uploads/';
    if (!file_exists($upload_path)) {
        mkdir($upload_path, 0777, true);
    }

    // Generate unique filename
    $filename = uniqid() . '_' . time() . '.' . $file_extension;
    $destination = $upload_path . $filename;

    // Move uploaded file
    if (move_uploaded_file($file['tmp_name'], $destination)) {
        $file_url = '/backend/uploads/' . $filename;

        // Log activity
        $database = new Database();
        $conn = $database->getConnection();
        
        $log_query = "INSERT INTO activity_logs (user_id, activity_type, description, ip_address) 
                      VALUES (:user_id, 'file_upload', :description, :ip)";
        $log_stmt = $conn->prepare($log_query);
        $description = "Uploaded file: {$file['name']}";
        $log_stmt->bindParam(':user_id', $user['id']);
        $log_stmt->bindParam(':description', $description);
        $log_stmt->bindParam(':ip', $_SERVER['REMOTE_ADDR']);
        $log_stmt->execute();

        sendResponse('success', 'File uploaded successfully', [
            'filename' => $filename,
            'url' => $file_url,
            'original_name' => $file['name'],
            'size' => $file['size'],
            'type' => $file['type']
        ], 201);
    } else {
        sendResponse('error', 'Failed to upload file', null, 500);
    }

} catch (Exception $e) {
    sendResponse('error', 'Upload error: ' . $e->getMessage(), null, 500);
}
?>
