<?php
/**
 * User Logout API
 */

// Define the root path of the project
define('ROOT_PATH', realpath(__DIR__ . '/../../..'));

require_once ROOT_PATH . '/backend/api/cors.php';
handleCORS();

require_once ROOT_PATH . '/backend/config/database.php';
require_once ROOT_PATH . '/backend/config/config.php';
require_once ROOT_PATH . '/backend/middleware/auth.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse('error', 'Method not allowed', null, 405);
}

$user = authenticate();

try {
    $database = new Database();
    $conn = $database->getConnection();

    // Get token from header
    $headers = getallheaders();
    $token = isset($headers['Authorization']) ? str_replace('Bearer ', '', $headers['Authorization']) : '';

    // Delete session
    $query = "DELETE FROM user_sessions WHERE session_token = :token";
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':token', $token);
    $stmt->execute();

    // Remove from online users
    $online_query = "DELETE FROM online_users WHERE user_id = :user_id";
    $online_stmt = $conn->prepare($online_query);
    $online_stmt->bindParam(':user_id', $user['id']);
    $online_stmt->execute();

    // Log activity
    $log_query = "INSERT INTO activity_logs (user_id, activity_type, description, ip_address) 
                  VALUES (:user_id, 'logout', 'User logged out', :ip)";
    $log_stmt = $conn->prepare($log_query);
    $log_stmt->bindParam(':user_id', $user['id']);
    $log_stmt->bindParam(':ip', $_SERVER['REMOTE_ADDR']);
    $log_stmt->execute();

    sendResponse('success', 'Logout successful', null, 200);

} catch (PDOException $e) {
    sendResponse('error', 'Database error: ' . $e->getMessage(), null, 500);
}
?>
