<?php
/**
 * List Announcements API
 */

// Define the root path of the project
define('ROOT_PATH', realpath(__DIR__ . '/../../..'));

require_once ROOT_PATH . '/backend/api/cors.php';
handleCORS();

require_once ROOT_PATH . '/backend/config/database.php';
require_once ROOT_PATH . '/backend/config/config.php';
require_once ROOT_PATH . '/backend/middleware/auth.php';

$user = authenticate();

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    sendResponse('error', 'Method not allowed', null, 405);
}

try {
    $database = new Database();
    $conn = $database->getConnection();

    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $limit = 10;
    $offset = ($page - 1) * $limit;

    $query = "SELECT 
                a.id,
                a.admin_id,
                a.title,
                a.content,
                a.announcement_type,
                a.attachment_url,
                a.is_pinned,
                a.views_count,
                a.created_at,
                a.updated_at,
                u.username as admin_username,
                u.full_name as admin_name,
                u.profile_picture as admin_profile_picture
              FROM announcements a
              JOIN users u ON a.admin_id = u.id
              ORDER BY a.is_pinned DESC, a.created_at DESC
              LIMIT :limit OFFSET :offset";
    
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);
    $stmt->bindParam(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();

    $announcements = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Get reactions for each announcement
    foreach ($announcements as &$announcement) {
        $reaction_query = "SELECT ar.reaction_type as type, ar.user_id, u.username 
                          FROM announcement_reactions ar
                          JOIN users u ON ar.user_id = u.id
                          WHERE ar.announcement_id = :announcement_id";
        $reaction_stmt = $conn->prepare($reaction_query);
        $reaction_stmt->bindParam(':announcement_id', $announcement['id']);
        $reaction_stmt->execute();
        $announcement['reactions'] = $reaction_stmt->fetchAll(PDO::FETCH_ASSOC);
        $announcement['reaction_count'] = count($announcement['reactions']);
        $announcement['user_has_reacted'] = false;
        
        foreach ($announcement['reactions'] as $reaction) {
            if ($reaction['user_id'] == $user['id']) {
                $announcement['user_has_reacted'] = true;
                $announcement['user_reaction_type'] = $reaction['type'];
                break;
            }
        }
    }

    // Get total count
    $count_query = "SELECT COUNT(*) as total FROM announcements";
    $count_stmt = $conn->query($count_query);
    $total = $count_stmt->fetch(PDO::FETCH_ASSOC)['total'];

    sendResponse('success', 'Announcements retrieved', [
        'announcements' => $announcements,
        'pagination' => [
            'page' => $page,
            'limit' => $limit,
            'total' => (int)$total,
            'total_pages' => ceil($total / $limit)
        ]
    ], 200);

} catch (PDOException $e) {
    sendResponse('error', 'Database error: ' . $e->getMessage(), null, 500);
}
?>
