<?php
/**
 * Create Announcement API (Admin/Moderator only)
 */

// Define the root path of the project
define('ROOT_PATH', realpath(__DIR__ . '/../../..'));

require_once ROOT_PATH . '/backend/api/cors.php';
handleCORS();

require_once ROOT_PATH . '/backend/config/database.php';
require_once ROOT_PATH . '/backend/config/config.php';
require_once ROOT_PATH . '/backend/middleware/auth.php';

$user = requireAdmin();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse('error', 'Method not allowed', null, 405);
}

$data = json_decode(file_get_contents("php://input"));

if (empty($data->title) || empty($data->content)) {
    sendResponse('error', 'Title and content are required', null, 400);
}

try {
    $database = new Database();
    $conn = $database->getConnection();

    $announcement_type = $data->announcement_type ?? 'general';
    $attachment_url = $data->attachment_url ?? null;
    $is_pinned = isset($data->is_pinned) ? (bool)$data->is_pinned : false;

    $query = "INSERT INTO announcements (admin_id, title, content, announcement_type, attachment_url, is_pinned) 
              VALUES (:admin_id, :title, :content, :announcement_type, :attachment_url, :is_pinned)";
    
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':admin_id', $user['id']);
    $stmt->bindParam(':title', sanitizeInput($data->title));
    $stmt->bindParam(':content', sanitizeInput($data->content));
    $stmt->bindParam(':announcement_type', $announcement_type);
    $stmt->bindParam(':attachment_url', $attachment_url);
    $stmt->bindParam(':is_pinned', $is_pinned, PDO::PARAM_BOOL);
    
    if ($stmt->execute()) {
        $announcement_id = $conn->lastInsertId();

        // Create notifications for all users
        $notify_query = "INSERT INTO notifications (user_id, notification_type, title, content, reference_id)
                        SELECT id, 'announcement', :title, :content, :ref_id
                        FROM users WHERE is_active = 1 AND id != :admin_id";
        $notify_stmt = $conn->prepare($notify_query);
        $notify_title = "New Announcement: " . $data->title;
        $notify_stmt->bindParam(':title', $notify_title);
        $notify_stmt->bindParam(':content', $data->content);
        $notify_stmt->bindParam(':ref_id', $announcement_id);
        $notify_stmt->bindParam(':admin_id', $user['id']);
        $notify_stmt->execute();

        sendResponse('success', 'Announcement created', ['announcement_id' => $announcement_id], 201);
    } else {
        sendResponse('error', 'Failed to create announcement', null, 500);
    }

} catch (PDOException $e) {
    sendResponse('error', 'Database error: ' . $e->getMessage(), null, 500);
}
?>
